set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      NULL,
      67.223391,
      3,
      '1113441',
      35.135021,
      5,
      NULL,
      1,
      NULL,
      3,
      ' 6- 7-1997',
      136.486275,
      NULL,
      0.525709,
      NULL,
      2.115728,
      0,
      1.504461,
      NULL,
      0.935312,
      0.143633,
      0,
      0,
      1,
      0.888038,
      1.589012,
      0.375154,
      0.922184,
      1,
      1,
      NULL,
      6.108385,
      NULL,
      1.448906,
      1,
      1.903484,
      NULL,
      4,
      1,
      5.024260,
      1,
      0.036540,
      1.684468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.268315,
      1,
      1.019507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496615,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.495733,
      0,
      7.947716,
      7.147444,
      1.117205,
      3.646673,
      NULL,
      0,
      0.097525,
      0,
      NULL,
      1.662530,
      3.403929,
      1.804293,
      0,
      1.308961,
      1.246234,
      1,
      NULL,
      3.396403,
      1.287029,
      NULL,
      1.975108,
      1.378313,
      NULL,
      2.755164,
      1,
      0.011521,
      NULL,
      5,
      NULL,
      4.232545,
      NULL,
      2,
      0,
      5.255357,
      5,
      4.314350,
      NULL,
      4.386562,
      0,
      NULL,
      NULL,
      0.345316,
      2.308130,
      2,
      3.647194,
      0.853915,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.301534,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.410179,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996341,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407718,
      3,
      1.511135,
      0,
      2.229223,
      1,
      1.075411,
      0.519111,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      0.028028,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '1300',
      '1124',
      '42143',
      0,
      '',
      '',
      '',
      3,
      '3032',
      NULL,
      '',
      2.792713,
      NULL,
      3.836544,
      2,
      3.163676,
      1.338956,
      NULL,
      5.125484,
      3);
commit;
end;
/


