set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '24232424',
      18,
      30,
      '1421012',
      77.234054,
      1,
      1.515100,
      NULL,
      '133324',
      5,
      NULL,
      74,
      NULL,
      1.361501,
      NULL,
      NULL,
      0.372011,
      0,
      1,
      0,
      2.000722,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      0.179476,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.745229,
      NULL,
      1,
      0,
      1,
      0.756355,
      1,
      0.336324,
      0,
      NULL,
      NULL,
      1.503243,
      NULL,
      NULL,
      0,
      1,
      0.131992,
      1,
      1,
      1.835185,
      0,
      1.308595,
      1,
      0,
      2.872160,
      1,
      NULL,
      0,
      NULL,
      0.512866,
      0.859596,
      1.800786,
      0,
      NULL,
      0.020242,
      0.539830,
      1,
      0,
      2,
      1,
      1.371940,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      7,
      7,
      NULL,
      1,
      1.855212,
      5,
      NULL,
      1.952440,
      1,
      1.029267,
      3,
      1.022490,
      0.662734,
      0.949090,
      1.943447,
      3,
      NULL,
      2.402198,
      0,
      5.515091,
      0,
      NULL,
      1,
      NULL,
      1.665862,
      NULL,
      1.819293,
      3.304675,
      1,
      4,
      0,
      NULL,
      1.666079,
      1.656344,
      NULL,
      1,
      NULL,
      0.365301,
      0.449924,
      4,
      4,
      NULL,
      3.644108,
      NULL,
      7,
      0.854406,
      1.435902,
      0,
      2,
      0.394427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0.058338,
      4,
      0.037300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.900940,
      0.857792,
      0.741533,
      NULL,
      0.453222,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.730027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.052064,
      0.191186,
      2,
      NULL,
      1.219797,
      2,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '04323',
      NULL,
      NULL,
      '',
      '',
      '',
      3.628300,
      '0010',
      '',
      '',
      4,
      3,
      3,
      3.412993,
      NULL,
      2.919402,
      3,
      0,
      3);
commit;
end;
/


