set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2010',
      '42234330',
      NULL,
      60,
      '0343321',
      76.191673,
      4,
      1,
      1,
      '443121',
      5,
      ' 9-26-1980',
      132.772908,
      21.640473,
      1.647850,
      NULL,
      2.997323,
      1.233196,
      1.958531,
      0,
      0.865765,
      1,
      1,
      0.760484,
      0.855722,
      1,
      0,
      NULL,
      0,
      5.107752,
      1,
      1,
      NULL,
      NULL,
      0.615618,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.617930,
      1,
      2.456837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102483,
      0,
      0,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      4,
      2,
      NULL,
      3,
      NULL,
      2,
      1.059604,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.955356,
      1.756112,
      1,
      3.098366,
      NULL,
      NULL,
      3.984709,
      0.831379,
      5.979745,
      5,
      1.745629,
      NULL,
      NULL,
      0.074240,
      2,
      0.239019,
      0,
      0,
      0.390213,
      0.129580,
      0,
      3.276155,
      1.652523,
      7,
      1.612065,
      2,
      7,
      7.581190,
      7,
      NULL,
      0,
      3.120130,
      NULL,
      0.780617,
      2.095144,
      0.155605,
      1.226961,
      3.323718,
      0.237097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870207,
      1,
      2.621190,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.627307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      6.427473,
      1.712882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.390261,
      NULL,
      NULL,
      2,
      1.753538,
      NULL,
      NULL,
      NULL,
      0,
      7.677595,
      1.251375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896193,
      0,
      1,
      2.934025,
      0,
      0.902465,
      1.154794,
      0,
      2.252735,
      3,
      0.743043,
      1,
      1,
      0.423144,
      0,
      0.917890,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.201651,
      NULL,
      '04441',
      NULL,
      1,
      NULL,
      '',
      '',
      1.991139,
      '2141',
      '',
      '',
      5,
      NULL,
      3.707285,
      NULL,
      0,
      NULL,
      0.419585,
      3.176417,
      2.753954);
commit;
end;
/


