set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      30.691243,
      67.125180,
      '3402034',
      96.548525,
      NULL,
      0.170621,
      NULL,
      '434111',
      4,
      ' 2-18-1977',
      33.207587,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.755702,
      0,
      3,
      NULL,
      NULL,
      0.001316,
      NULL,
      1,
      1.977256,
      NULL,
      3.481055,
      0.903665,
      0.068748,
      NULL,
      0.807962,
      1.056945,
      1.710339,
      NULL,
      NULL,
      7.686398,
      1,
      3.150494,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.184374,
      NULL,
      NULL,
      5,
      3,
      2.498828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868285,
      0.886159,
      1.344644,
      1,
      NULL,
      1.566668,
      0.119404,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.792312,
      0,
      4,
      0.029538,
      2,
      0.384181,
      1.210353,
      1.787610,
      6.074890,
      NULL,
      1,
      0,
      6,
      0.200081,
      0,
      1.383974,
      1.425940,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      7.247132,
      5.205628,
      0.146826,
      3.618731,
      0.765971,
      NULL,
      5.898086,
      0,
      NULL,
      NULL,
      0.178637,
      6.772413,
      0.635876,
      3,
      4,
      2.618513,
      9.316564,
      9,
      8.279318,
      NULL,
      0,
      NULL,
      1,
      0.297946,
      0.917099,
      NULL,
      3,
      0.405129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147059,
      0.352305,
      0,
      2,
      1.263984,
      2,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939200,
      0,
      0.400932,
      0.338334,
      1.606251,
      3.181048,
      4.823589,
      3.668846,
      NULL,
      NULL,
      NULL,
      NULL,
      3.279245,
      0.560988,
      1,
      1.714445,
      NULL,
      NULL,
      1.145696,
      NULL,
      NULL,
      NULL,
      1.611334,
      6.102174,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.246171,
      0.645561,
      2.002897,
      3.513459,
      NULL,
      3.774286,
      2,
      NULL,
      NULL,
      1.591194,
      NULL,
      0.090480,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.571276,
      '2103',
      '33010',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.922694,
      '1031',
      '',
      '',
      5,
      5.306223,
      NULL,
      1,
      1,
      1,
      0.677169,
      4,
      0.015786);
commit;
end;
/


