set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1012',
      '22403331',
      42,
      10,
      '3324110',
      NULL,
      3,
      NULL,
      2,
      '112030',
      3.126973,
      ' 4- 6-1979',
      40,
      NULL,
      0.609837,
      NULL,
      0.524130,
      0.387338,
      1.014464,
      0.785103,
      NULL,
      2,
      0,
      3,
      1.288904,
      NULL,
      6,
      0,
      NULL,
      8.147568,
      1,
      1,
      2.458635,
      NULL,
      0.273309,
      0,
      NULL,
      0.266701,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.926874,
      NULL,
      2.742517,
      3.729847,
      0.261468,
      0.170924,
      1.214513,
      0.876232,
      1,
      NULL,
      0.084115,
      0.038165,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      2,
      NULL,
      1.601959,
      5,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      1.345513,
      NULL,
      NULL,
      3.680363,
      5.963564,
      1.488878,
      4.371515,
      4.720654,
      5,
      2.889979,
      0.468534,
      NULL,
      3.368213,
      2,
      0.949896,
      NULL,
      1,
      0.929177,
      0.569223,
      1,
      1.822750,
      1,
      NULL,
      1,
      1.856272,
      5,
      0.523612,
      0,
      5.616478,
      NULL,
      0.453719,
      7,
      1.864077,
      1,
      NULL,
      NULL,
      NULL,
      4.009601,
      5,
      NULL,
      9,
      8,
      3.842466,
      NULL,
      8,
      2,
      10,
      9,
      NULL,
      NULL,
      1,
      1.365637,
      0,
      0.742645,
      7.712555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.967755,
      NULL,
      2,
      NULL,
      NULL,
      7.226079,
      0.347352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.073146,
      NULL,
      1.158387,
      2.463147,
      NULL,
      1.621385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.311744,
      NULL,
      0.577743,
      NULL,
      1.065094,
      NULL,
      NULL,
      NULL,
      0,
      2.603843,
      0.429951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964948,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      3,
      0,
      1.447031,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.996823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.849369,
      NULL,
      '12223',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '1032',
      '',
      '',
      1,
      5,
      2.470368,
      2,
      2.689437,
      1.110474,
      3,
      NULL,
      3.585826);
commit;
end;
/


