set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9629538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40',
      25,
      14.243303,
      '2004304',
      7.041708,
      NULL,
      1.484023,
      NULL,
      '440002',
      3,
      '10-27-1988',
      55,
      44.170720,
      1,
      NULL,
      1.870053,
      0,
      0.093508,
      0,
      0.338590,
      1.946913,
      1.474967,
      3.745352,
      0,
      0,
      NULL,
      3.719019,
      1.899975,
      NULL,
      0.193039,
      NULL,
      2,
      NULL,
      1,
      0.052680,
      1,
      NULL,
      4.871486,
      0,
      2.000054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4,
      6.135163,
      NULL,
      0.004657,
      0.691831,
      0.012467,
      1.482244,
      1.034670,
      NULL,
      3,
      1.797417,
      1.585317,
      2,
      1.625842,
      1,
      0.348297,
      1.023397,
      3,
      0,
      1,
      0.122570,
      7.007459,
      NULL,
      0,
      1.335256,
      0,
      NULL,
      NULL,
      0.011240,
      NULL,
      NULL,
      0.784725,
      2.691487,
      3.975096,
      0,
      NULL,
      1,
      0,
      0.132273,
      0.869608,
      NULL,
      0,
      1.208387,
      0.286000,
      0,
      1,
      NULL,
      NULL,
      1.050985,
      1.339617,
      NULL,
      NULL,
      2.440735,
      0.068184,
      NULL,
      5.204895,
      NULL,
      NULL,
      1,
      7,
      2,
      3,
      NULL,
      1,
      0,
      6.998848,
      5.691390,
      3,
      NULL,
      NULL,
      6.772319,
      3.230060,
      NULL,
      9,
      0,
      9.436662,
      1,
      NULL,
      0,
      NULL,
      1.389181,
      NULL,
      NULL,
      0.921741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654284,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.362945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.816878,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.362282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992461,
      NULL,
      3.548870,
      1.787424,
      2,
      2.305386,
      1.874920,
      NULL,
      1,
      0.204247,
      NULL,
      1,
      1.023685,
      1,
      1.315921,
      0,
      0.717488,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.690356,
      '34401',
      NULL,
      '',
      1.664349,
      '',
      '',
      '',
      1.189603,
      NULL,
      '',
      '',
      1.842074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


