set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8111275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '02210344',
      NULL,
      68,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '230134',
      5.917537,
      ' 6-18-1988',
      28.034570,
      27,
      1,
      NULL,
      0,
      0,
      1,
      1.751290,
      0,
      2.106100,
      1.379393,
      NULL,
      1.628627,
      0,
      1,
      0.571615,
      5.149580,
      4,
      0.464995,
      0,
      3,
      0,
      1.959830,
      NULL,
      0,
      0.533468,
      2.151736,
      1,
      1,
      1,
      NULL,
      1.764378,
      NULL,
      NULL,
      1.262647,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1.094447,
      3.845982,
      1.168115,
      0.957327,
      NULL,
      1,
      1.172936,
      0.611095,
      3.433118,
      1.457180,
      3.223926,
      0,
      NULL,
      2.485817,
      NULL,
      1,
      0.026255,
      2.054230,
      NULL,
      0,
      NULL,
      1.357193,
      NULL,
      NULL,
      0.944520,
      NULL,
      NULL,
      1,
      0,
      0,
      0.906086,
      1.482842,
      1,
      1,
      0,
      0,
      0.096526,
      0.734274,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1.520895,
      1,
      1.473687,
      2.831218,
      2.335799,
      0.050248,
      4,
      0,
      NULL,
      0.034804,
      0.526266,
      NULL,
      NULL,
      0,
      4.180104,
      1.616283,
      0.809283,
      2,
      0.627215,
      4.204818,
      3.207010,
      NULL,
      0.550020,
      2,
      4,
      4.544893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.527551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.282952,
      0.057350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523957,
      1.949912,
      1.659047,
      1.449784,
      4,
      6,
      3.114516,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.539552,
      1.785696,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.245256,
      1.621360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.214401,
      NULL,
      2.899732,
      3.464404,
      1,
      2.791245,
      0,
      1.211045,
      1.245238,
      0.183981,
      0.524219,
      1,
      1.403516,
      0,
      0.888710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.544508,
      '23324',
      '03014',
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      3.568054,
      1,
      0.409508,
      5,
      3,
      NULL,
      2.281594);
commit;
end;
/


