set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9220323';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '024',
      NULL,
      44.260778,
      5.444154,
      '1232342',
      63,
      1,
      NULL,
      2,
      '103132',
      5.098118,
      ' 9- 2-1992',
      45.594401,
      25,
      1.253543,
      NULL,
      0,
      1,
      2.831943,
      1,
      1.198563,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0.036867,
      1.420832,
      NULL,
      1,
      0,
      1,
      0.355189,
      0,
      0,
      0,
      0.299219,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.458090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429957,
      1.875007,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1.539760,
      1.803204,
      0,
      0,
      1,
      1.836795,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0.900546,
      1,
      NULL,
      1.975435,
      1.172593,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966186,
      1,
      0,
      NULL,
      1,
      1.287826,
      3.964432,
      2.440272,
      NULL,
      0,
      NULL,
      1,
      0,
      1.187532,
      1,
      0,
      NULL,
      NULL,
      NULL,
      6.849722,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.395513,
      1,
      0,
      0,
      NULL,
      1,
      0.416509,
      0.719074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.539600,
      NULL,
      3,
      3.801975,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.043373,
      6,
      3,
      3.214431,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.556164,
      3.388268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368106,
      1,
      NULL,
      NULL,
      NULL,
      1.601541,
      1.066893,
      0.101531,
      1.137609,
      0.440754,
      0.333226,
      1.136794,
      1.502308,
      0.755525,
      NULL,
      NULL,
      1,
      NULL,
      0.348850,
      1.685803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252520,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937259,
      1.990331,
      1,
      NULL,
      0.103110,
      0.851891,
      0.257217,
      1,
      1.154524,
      '0032',
      '',
      NULL,
      0.041232,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


