set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693193';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      NULL,
      6.293145,
      41.817108,
      '3021022',
      NULL,
      1,
      1,
      1,
      '134310',
      NULL,
      ' 4-29-1981',
      12.057973,
      21,
      0.606824,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2.876565,
      1.682431,
      NULL,
      0.903513,
      0.450373,
      1.445125,
      0.994147,
      0,
      3,
      1.398587,
      0,
      2,
      0,
      NULL,
      1,
      1.130583,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.974970,
      1.207312,
      NULL,
      NULL,
      0.821367,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.730400,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021746,
      NULL,
      4.710017,
      0.963477,
      NULL,
      NULL,
      0.085268,
      1.113510,
      0.371190,
      6,
      1,
      1,
      1.283733,
      2.996777,
      0,
      1.246454,
      1,
      NULL,
      0.259031,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.435171,
      NULL,
      1.455209,
      0.322480,
      0,
      1,
      0,
      0.961077,
      NULL,
      0.516465,
      2.826088,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      3.277194,
      3.097583,
      NULL,
      1.322605,
      NULL,
      NULL,
      5.188600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264106,
      0,
      0,
      1,
      1.925729,
      1,
      1,
      1.760405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.520161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180330,
      1.650968,
      1.135501,
      0.108823,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938353,
      1.211916,
      1.059131,
      NULL,
      NULL,
      0,
      NULL,
      1.831710,
      0,
      3.743589,
      NULL,
      1,
      1.139075,
      NULL,
      1.509466,
      0,
      0,
      1.496608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '41112',
      '',
      '',
      1.178579,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      3,
      2.947983,
      3.060867,
      1.719046,
      5.295212,
      NULL,
      3.282185,
      NULL);
commit;
end;
/


