set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '4212201',
      11,
      NULL,
      NULL,
      2,
      '244211',
      2,
      '10-20-1984',
      29,
      NULL,
      0.316045,
      NULL,
      1,
      1.057393,
      0.426410,
      1,
      1.438765,
      NULL,
      1,
      1.054481,
      NULL,
      0,
      NULL,
      0.941165,
      3.227047,
      1.636200,
      1,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      7.283054,
      1,
      2.825493,
      1.476573,
      2,
      1,
      NULL,
      NULL,
      0.996196,
      NULL,
      NULL,
      9,
      0.665703,
      0,
      1.223076,
      1.470805,
      1,
      0,
      0,
      0.668381,
      NULL,
      3.735721,
      1,
      1,
      3.976136,
      1.357029,
      3.946453,
      0.532773,
      NULL,
      0.589255,
      0.561898,
      0.657136,
      0.992723,
      NULL,
      NULL,
      0,
      1.828343,
      0.141304,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.535945,
      0,
      0.247557,
      NULL,
      1.018790,
      0,
      1,
      1,
      0.671621,
      0.874869,
      1.431320,
      0.536513,
      0,
      1.782185,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1.557875,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.148603,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.507463,
      0,
      0,
      2,
      NULL,
      2.717517,
      1,
      NULL,
      1,
      3.631983,
      10.588700,
      0.911943,
      5.151323,
      0.526854,
      2.884457,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.560315,
      NULL,
      1,
      1.169160,
      NULL,
      1.356354,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.800259,
      NULL,
      7.432938,
      2.102153,
      NULL,
      1.549984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.912739,
      NULL,
      NULL,
      NULL,
      4.537660,
      NULL,
      1.125343,
      2.500498,
      3.527877,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707989,
      NULL,
      0.079665,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      3.969865,
      0,
      1,
      0.684880,
      1,
      0,
      0,
      0,
      0.962304,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '34344',
      '',
      NULL,
      0.976410,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


