set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '3141424',
      49.529743,
      1,
      2.015347,
      2,
      '304041',
      0,
      ' 1-13-1991',
      NULL,
      NULL,
      0,
      NULL,
      0.810847,
      3.525563,
      0,
      1,
      0.775656,
      1.290644,
      3.012771,
      2,
      2,
      1,
      NULL,
      NULL,
      1.953795,
      0.714335,
      1.403904,
      1.448735,
      2,
      NULL,
      1,
      1,
      1,
      1.871255,
      4.690351,
      1,
      0,
      1,
      2.551264,
      1.064897,
      NULL,
      NULL,
      0.595417,
      NULL,
      NULL,
      9.889381,
      0.964727,
      1.360758,
      NULL,
      0.578371,
      3,
      1,
      NULL,
      1.643032,
      2.005339,
      2,
      1,
      1,
      NULL,
      1,
      3.794213,
      0.459832,
      0,
      0.933535,
      1,
      1,
      1,
      5,
      0,
      2,
      3,
      0.065804,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.136538,
      1.504007,
      2.619244,
      1.654138,
      1.638296,
      0.549397,
      0,
      0.542622,
      0.253008,
      1.418959,
      0.035726,
      NULL,
      0.809299,
      NULL,
      0.545964,
      NULL,
      NULL,
      NULL,
      1.732506,
      7,
      3,
      0,
      1.858826,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0.646882,
      1,
      NULL,
      0,
      5.381455,
      5.450652,
      5,
      3.163442,
      7.614239,
      3.188174,
      0.398620,
      11.440941,
      NULL,
      5,
      3,
      NULL,
      1.254016,
      1,
      1,
      5.397147,
      0.357852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134625,
      0.311587,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.252349,
      1.534339,
      0.468261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.566704,
      1.154217,
      4.974930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334258,
      0.823511,
      0,
      NULL,
      NULL,
      1.109453,
      2,
      1,
      0,
      2.239570,
      3,
      1,
      0,
      1.683464,
      NULL,
      0,
      1.071546,
      NULL,
      1.838780,
      0.204524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.755823,
      '04300',
      '',
      NULL,
      1.395241,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


