set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      83,
      0,
      0,
      0,
      '341200',
      2.206583,
      '11- 8-1978',
      18,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1.494162,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      1.723851,
      NULL,
      4.750396,
      2.748122,
      5.067307,
      0,
      5,
      1.857359,
      NULL,
      0.987459,
      NULL,
      NULL,
      NULL,
      0.402055,
      0.987551,
      5,
      0.068214,
      0,
      0.553954,
      1.409145,
      0.735245,
      0,
      NULL,
      1,
      1,
      0,
      1.171638,
      3,
      0,
      NULL,
      2,
      1,
      NULL,
      2.684760,
      1.658799,
      NULL,
      0,
      3,
      0,
      1,
      2.241894,
      NULL,
      NULL,
      NULL,
      3,
      2.253603,
      2.573721,
      1,
      0,
      0.159526,
      0.693289,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1.934873,
      1.039745,
      0.412635,
      0.368566,
      0.834761,
      NULL,
      1,
      0.888465,
      NULL,
      NULL,
      1.565330,
      NULL,
      NULL,
      NULL,
      0.891465,
      0.834956,
      NULL,
      0.612315,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.414725,
      NULL,
      NULL,
      0,
      5,
      4,
      NULL,
      1.838761,
      NULL,
      4.371937,
      0.903435,
      NULL,
      2.446046,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005626,
      NULL,
      1,
      0.099136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.792159,
      NULL,
      4,
      1,
      0,
      0.908299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570670,
      NULL,
      NULL,
      2,
      1.976403,
      1,
      1,
      NULL,
      3.581856,
      0.731889,
      NULL,
      2,
      0.168490,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      0,
      6.899673,
      4,
      0.205262,
      NULL,
      1.232066,
      1,
      1.561334,
      3,
      NULL,
      1,
      1.780183,
      0.292198,
      1.523429,
      0,
      0,
      0,
      1.198625,
      1,
      0.884028,
      NULL,
      0.185458,
      1,
      1.553984,
      0.857696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '32412',
      NULL,
      '',
      0.726709,
      '',
      '',
      '',
      0.417542,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


