set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '033',
      '40',
      NULL,
      2,
      '4102013',
      16,
      NULL,
      NULL,
      1,
      '303000',
      1,
      NULL,
      20.359473,
      2.912075,
      0,
      NULL,
      1,
      0.962704,
      0,
      0.678180,
      0.701960,
      1,
      NULL,
      2,
      0.211249,
      1.725601,
      NULL,
      0.204794,
      0.123227,
      1.125470,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      5.356268,
      NULL,
      7,
      NULL,
      0.900366,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.671257,
      1,
      NULL,
      1.964338,
      1,
      0.248983,
      0.346815,
      2.206383,
      1,
      0,
      NULL,
      0,
      2.093438,
      1.489086,
      0.156144,
      1,
      1,
      1.976299,
      NULL,
      1.818068,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.026426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.214627,
      1,
      NULL,
      0,
      0.582444,
      1,
      1.702439,
      0.282612,
      1,
      1.801380,
      0,
      NULL,
      NULL,
      0.887689,
      0.989597,
      1,
      NULL,
      0.073479,
      1.687836,
      1.683136,
      4,
      0,
      NULL,
      4.278615,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.675804,
      NULL,
      NULL,
      1.140700,
      0,
      NULL,
      0,
      3.757706,
      1,
      7.167937,
      7.819799,
      NULL,
      8,
      1,
      1.924359,
      NULL,
      0,
      1,
      0,
      1.573988,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195946,
      1,
      NULL,
      0,
      0,
      0,
      1.687305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      1.409429,
      2.490634,
      0.414450,
      1.810532,
      6,
      5.085861,
      0.620725,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.232415,
      0.169989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016397,
      3.860252,
      1,
      2.959013,
      0,
      2,
      1,
      0.507041,
      1.965606,
      0,
      1.721563,
      NULL,
      0.241470,
      1,
      0.265340,
      1.237753,
      1,
      1.901384,
      0.717399,
      0.981265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '34200',
      '',
      '',
      1.966452,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      5.973055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


