set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      NULL,
      8.377224,
      2,
      '4420423',
      NULL,
      2,
      0.000235,
      1,
      '320024',
      1.725414,
      ' 7- 1-1983',
      26.012051,
      1.905596,
      0,
      NULL,
      0.651236,
      1,
      1.979001,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0.875043,
      NULL,
      0,
      2,
      1.135894,
      1.158093,
      NULL,
      1,
      0,
      3,
      4,
      6.956406,
      0,
      NULL,
      NULL,
      1.527886,
      0.545348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.957560,
      0,
      0.516701,
      3.426480,
      0.550828,
      3,
      0.611439,
      0,
      NULL,
      0.472201,
      NULL,
      0.749364,
      NULL,
      0,
      3.474336,
      1,
      NULL,
      0,
      2,
      4.759177,
      1,
      1.918644,
      2.433539,
      1,
      1,
      3.193472,
      1.283705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.876265,
      1.483585,
      0.749393,
      1.257029,
      0.912965,
      1,
      0,
      0,
      1.886911,
      NULL,
      NULL,
      NULL,
      1.992222,
      0,
      NULL,
      0,
      NULL,
      1.284533,
      3.143174,
      NULL,
      4,
      5,
      0,
      0.217683,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.900983,
      0.572667,
      0.056767,
      1,
      3,
      3.621485,
      2,
      6.159052,
      6.319889,
      3,
      2,
      0.108965,
      5,
      NULL,
      0.893485,
      1.828625,
      1.017383,
      1.178873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0.969004,
      0,
      1.366446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      1.133638,
      NULL,
      0.328085,
      0,
      5,
      0.213350,
      4.349767,
      1,
      0.104371,
      1,
      0.459137,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.505965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312375,
      3.861810,
      0,
      3.998369,
      0.408586,
      1.524506,
      2,
      NULL,
      2,
      NULL,
      NULL,
      0.927441,
      0.793801,
      0.755161,
      1,
      NULL,
      1,
      0.257074,
      0.391644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595681,
      '12411',
      '',
      '',
      0.716890,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


