set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '011',
      '40',
      NULL,
      17,
      '3403301',
      94.037139,
      4,
      1,
      0,
      '240433',
      2,
      ' 0-24-1983',
      NULL,
      47.896433,
      NULL,
      NULL,
      0.048074,
      NULL,
      2.739995,
      0.424658,
      1.406155,
      0,
      NULL,
      2.699736,
      0,
      0.920660,
      NULL,
      0,
      NULL,
      0,
      0.501903,
      3,
      1.136448,
      1.331456,
      NULL,
      1,
      NULL,
      2.852438,
      6,
      1,
      3.816890,
      3,
      NULL,
      1.087492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554527,
      3,
      1.852449,
      0.305671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564715,
      3,
      0,
      1,
      0.925623,
      0,
      0,
      0,
      3,
      0.098586,
      1,
      7.502520,
      1,
      0,
      3.984342,
      0.457211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.961725,
      0,
      1,
      NULL,
      0.770319,
      NULL,
      1,
      1.854880,
      0.945599,
      NULL,
      0.282726,
      1,
      1.548875,
      1,
      0.036709,
      1,
      1.580931,
      1.492950,
      1.835285,
      NULL,
      0.869097,
      1,
      5,
      NULL,
      NULL,
      1,
      5.832049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.786456,
      4.023201,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      8.820202,
      4,
      1,
      4.263276,
      3,
      1.512033,
      1.379617,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094164,
      0,
      NULL,
      0,
      0.744543,
      0,
      1.504730,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.979054,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.669949,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.591557,
      0,
      0.650370,
      NULL,
      NULL,
      NULL,
      1.987014,
      3.083051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750038,
      2.059305,
      NULL,
      1.937665,
      1.586848,
      2,
      1.196839,
      2,
      NULL,
      3,
      NULL,
      0,
      1,
      0.993658,
      1.790961,
      1,
      1,
      0.082892,
      0.567979,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.412970,
      '00043',
      NULL,
      '',
      1.311048,
      NULL,
      '',
      '',
      1.223059,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


