set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '03',
      34.089536,
      17.327976,
      '2223400',
      101,
      NULL,
      2.504444,
      3,
      '004203',
      4.484996,
      ' 7-10-1995',
      12,
      NULL,
      1,
      NULL,
      1,
      1.102448,
      NULL,
      0,
      0.076118,
      0,
      NULL,
      NULL,
      0,
      0.567855,
      0.350826,
      1.158384,
      NULL,
      NULL,
      NULL,
      1,
      3.697460,
      NULL,
      1.024587,
      NULL,
      0.010499,
      5.543943,
      3.587674,
      1,
      5.016639,
      2,
      1.565235,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.651232,
      1,
      NULL,
      0.357422,
      1.048324,
      1,
      1.206517,
      1,
      0.183896,
      1.409905,
      3.279490,
      1,
      0,
      NULL,
      2,
      0.839803,
      0.050649,
      0.638921,
      0.607421,
      2,
      0.717360,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.865733,
      NULL,
      NULL,
      1.807317,
      NULL,
      0,
      1,
      0.461527,
      2,
      1,
      1.755811,
      NULL,
      1,
      1,
      0,
      1.621925,
      NULL,
      1.924908,
      NULL,
      0.267935,
      NULL,
      0.539102,
      NULL,
      1.992369,
      5.645253,
      NULL,
      0,
      1.678969,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911721,
      1.087297,
      NULL,
      0,
      1.040201,
      1.765336,
      1,
      0,
      0,
      0,
      6.555482,
      0,
      4,
      3.005504,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0.280834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9,
      3,
      0.230353,
      1.533394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.114391,
      NULL,
      3.417746,
      0,
      NULL,
      NULL,
      0,
      NULL,
      7,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.801561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.323198,
      1.314690,
      3.336320,
      3,
      0.648083,
      1.328338,
      3,
      1.697441,
      1,
      1,
      0.638818,
      NULL,
      0.274401,
      1.833610,
      1.702641,
      1.687352,
      0,
      0,
      1.914789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.755974,
      '10013',
      '',
      '',
      0.810782,
      '',
      '',
      '',
      1.236374,
      '',
      '',
      '',
      0.870984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


