set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '02',
      36,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '020013',
      1.580198,
      NULL,
      1,
      34,
      0,
      NULL,
      0,
      1,
      NULL,
      1.969710,
      1,
      1.780064,
      1.564643,
      3.560481,
      1.732299,
      0.197373,
      1.270388,
      NULL,
      0.631269,
      NULL,
      1,
      0.360121,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.829999,
      0,
      NULL,
      0,
      3.572229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.166585,
      1.156668,
      0.584801,
      NULL,
      NULL,
      NULL,
      0.384571,
      1.121813,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      0,
      2.607240,
      NULL,
      1,
      NULL,
      1.746541,
      1,
      4.289130,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1.209965,
      NULL,
      NULL,
      0,
      0.496258,
      1.786960,
      1.787299,
      0.008186,
      3.404877,
      1,
      0,
      1.348058,
      1.211472,
      1,
      0.055732,
      0.050698,
      NULL,
      1.864143,
      0,
      1,
      0,
      NULL,
      NULL,
      0.451915,
      5,
      4,
      3,
      3.884925,
      0.233364,
      1,
      3.326447,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.393374,
      0.146545,
      1.966147,
      0.194244,
      1,
      6.843781,
      1.647348,
      2,
      4,
      6,
      NULL,
      0,
      1.761520,
      NULL,
      NULL,
      1.556748,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146810,
      0,
      1,
      0,
      0.495604,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.876026,
      3.598644,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525215,
      1,
      NULL,
      1.613007,
      1.439541,
      0,
      NULL,
      2.591828,
      0.050026,
      1,
      1,
      1,
      1.308516,
      NULL,
      NULL,
      NULL,
      1.908544,
      4,
      0.194332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.410540,
      3.114220,
      3,
      0.850187,
      NULL,
      3,
      1,
      3.506102,
      NULL,
      1.394247,
      NULL,
      NULL,
      NULL,
      0.057144,
      1.589790,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '01332',
      '',
      '',
      1.756697,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2,
      NULL,
      0.812205,
      4.829056,
      3.455373,
      NULL,
      2.175740,
      1.278089,
      0);
commit;
end;
/


