set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      '42413122',
      45.043804,
      39.124028,
      '0004232',
      78.451931,
      1,
      3.857350,
      NULL,
      '321230',
      4,
      NULL,
      59,
      36.805454,
      0.056984,
      NULL,
      1.951763,
      0,
      1.716143,
      NULL,
      0,
      1.233150,
      NULL,
      1,
      0,
      1,
      NULL,
      1.151259,
      0.030325,
      0,
      3.867932,
      2.192109,
      3.335141,
      4,
      0.933910,
      NULL,
      0,
      9.419564,
      NULL,
      0,
      4,
      NULL,
      0,
      0.345784,
      NULL,
      NULL,
      1.172238,
      NULL,
      NULL,
      9,
      NULL,
      1.092544,
      NULL,
      NULL,
      NULL,
      0,
      0.947380,
      0.597891,
      1.771425,
      0.534095,
      1.213233,
      3.786280,
      0,
      0,
      2,
      1.125887,
      3.485095,
      3,
      1,
      NULL,
      0.653360,
      6,
      1,
      2,
      1.829629,
      0.331689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496574,
      1,
      0,
      1,
      1.384265,
      3.233054,
      1.722698,
      0,
      0.875191,
      0.404797,
      0.428904,
      0.474540,
      2,
      0.959476,
      0,
      1.968066,
      1,
      NULL,
      NULL,
      NULL,
      5.943606,
      1.556046,
      5.304602,
      7.613662,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.916118,
      NULL,
      0,
      NULL,
      1.674055,
      1,
      1,
      1.468297,
      4,
      0.010156,
      5.691436,
      1,
      6.731561,
      2.132181,
      5.887882,
      1,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282497,
      0,
      1,
      0,
      1.469936,
      0,
      0,
      1.282490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.582971,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      1.172143,
      NULL,
      NULL,
      1.674658,
      0.435100,
      0.386853,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828058,
      1,
      6,
      3.210701,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075759,
      3,
      1,
      0.601029,
      2.834813,
      0.527995,
      3.065937,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.834328,
      0.585873,
      1.741662,
      0.976463,
      1.285441,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.973626,
      '',
      '',
      '',
      NULL,
      NULL,
      1,
      4,
      2.396946,
      0.649555,
      NULL,
      2,
      NULL);
commit;
end;
/


