set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      '20310302',
      26,
      NULL,
      NULL,
      80.152059,
      4,
      2.731542,
      3,
      '104220',
      2.147604,
      '11- 2-1977',
      35,
      34,
      1.116623,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.629734,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.083968,
      2.906766,
      NULL,
      NULL,
      0.555949,
      NULL,
      3.357093,
      NULL,
      1,
      0,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.390005,
      1,
      0.083572,
      3,
      1.826883,
      2,
      0,
      0,
      0.665987,
      0.681128,
      2.000177,
      1.383923,
      2.399830,
      1,
      2.804399,
      0.319321,
      NULL,
      1.857408,
      0,
      NULL,
      1.504003,
      1.722108,
      9,
      0,
      1,
      2,
      0.766625,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.156657,
      1.982860,
      1,
      0.953478,
      0.844312,
      0,
      1.606543,
      0,
      1,
      1,
      0.139972,
      0.846405,
      1.670243,
      0,
      1.395295,
      NULL,
      1.650209,
      1.437069,
      NULL,
      1,
      1,
      4.453649,
      2.817994,
      7,
      0.971855,
      3.804355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.601305,
      NULL,
      NULL,
      1.379843,
      NULL,
      4,
      9.159943,
      NULL,
      9,
      8,
      3.264759,
      1,
      NULL,
      1.046301,
      0.998771,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.281557,
      NULL,
      0,
      1,
      0.322150,
      0.735709,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.084524,
      NULL,
      8,
      1,
      NULL,
      0.438661,
      NULL,
      2.346107,
      0.512882,
      1.530716,
      NULL,
      5,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1.610308,
      6.511831,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.223521,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359695,
      1,
      NULL,
      3.550743,
      2,
      3,
      2.631345,
      3,
      1,
      2,
      0,
      0.255265,
      NULL,
      0,
      1.215747,
      0.893449,
      1.482616,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '13220',
      '',
      '',
      1.945774,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      2.662385,
      NULL,
      1,
      1,
      0.106568,
      2.678391,
      0,
      0.012032,
      2.391331);
commit;
end;
/


