set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '33101233',
      NULL,
      40.789641,
      '1443013',
      NULL,
      1,
      1.019662,
      1,
      NULL,
      4,
      ' 1- 8-2000',
      37.747352,
      7,
      0,
      NULL,
      1,
      0,
      1.926720,
      0.336552,
      1.746142,
      1.507569,
      0,
      1.035403,
      0,
      1,
      1.055746,
      0,
      1,
      NULL,
      1.840134,
      NULL,
      3.086542,
      11.406585,
      1,
      0.904479,
      2,
      5.543392,
      9.810459,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.786258,
      0,
      1.914952,
      3,
      1.294526,
      NULL,
      NULL,
      1,
      NULL,
      2.582220,
      3.555472,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      0.236393,
      1,
      3.232508,
      NULL,
      2,
      3.847686,
      0.024673,
      NULL,
      NULL,
      0.696261,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.027314,
      1,
      1,
      0.282146,
      0,
      1.224828,
      0,
      1,
      NULL,
      1.929761,
      0.848034,
      1,
      NULL,
      1.050751,
      0,
      1,
      NULL,
      1.669830,
      3,
      5,
      7.241193,
      NULL,
      1.405978,
      6,
      2.684042,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      0.974000,
      3.272821,
      3.512717,
      NULL,
      6,
      4,
      11,
      1.747022,
      1.992312,
      0.978873,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353359,
      1.099248,
      0,
      NULL,
      0,
      1,
      0.777107,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.805318,
      NULL,
      1.592101,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.011089,
      3.568802,
      0,
      0,
      1.855751,
      0,
      3.316084,
      NULL,
      3,
      1,
      1,
      0.200642,
      NULL,
      NULL,
      NULL,
      0.937696,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.113521,
      3.259227,
      0.301301,
      3.973384,
      NULL,
      NULL,
      1,
      1.327168,
      0.057632,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '01432',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.301024,
      '',
      '',
      '',
      5,
      2.953132,
      2.037407,
      0,
      2,
      0,
      NULL,
      0,
      0);
commit;
end;
/


