set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      '40113130',
      42,
      57.369705,
      '2221442',
      56.987553,
      3,
      0.338672,
      NULL,
      '243012',
      5,
      ' 3- 2-1975',
      NULL,
      NULL,
      0.724604,
      NULL,
      0,
      0.432507,
      2.062824,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.611085,
      1,
      0.765418,
      1.172204,
      1,
      NULL,
      1.448943,
      1.297559,
      0,
      0.842069,
      NULL,
      NULL,
      NULL,
      0.663863,
      NULL,
      1,
      5.377053,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.352099,
      NULL,
      NULL,
      7,
      1,
      0,
      NULL,
      0,
      3,
      1.790771,
      1.943171,
      NULL,
      NULL,
      0.621294,
      0,
      3.814257,
      0.416663,
      NULL,
      3,
      1,
      0,
      1.738389,
      NULL,
      1.283599,
      0.034242,
      8,
      0,
      1,
      NULL,
      1.056044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.569371,
      1.907474,
      1.077465,
      0,
      2,
      1.460010,
      0,
      0.515601,
      0,
      0.716745,
      NULL,
      3.746167,
      0,
      0.838457,
      0,
      0.061805,
      0.358069,
      NULL,
      1.990272,
      5,
      0.073577,
      3.503712,
      NULL,
      0,
      NULL,
      0.570117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.202639,
      2.200441,
      1,
      1.497464,
      0,
      5.975032,
      NULL,
      4,
      4.225055,
      2,
      3,
      NULL,
      NULL,
      1.624452,
      1,
      0.633674,
      NULL,
      1.526421,
      1,
      0.392941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718740,
      1.463034,
      1,
      1,
      NULL,
      0.282216,
      0.795403,
      1.965468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.161594,
      NULL,
      0.953425,
      1.666956,
      1.971595,
      3.772832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.115152,
      NULL,
      1,
      2,
      2.532502,
      0.845038,
      1,
      1.233241,
      NULL,
      NULL,
      NULL,
      1.839868,
      0.556392,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.376380,
      NULL,
      NULL,
      1.506755,
      1,
      1,
      3,
      0.747863,
      1,
      0.475681,
      1,
      0.778840,
      0,
      1,
      0.930734,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11342',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      2,
      2,
      1.357312,
      NULL,
      3.720419,
      0.419832,
      3);
commit;
end;
/


