set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      NULL,
      67.669534,
      NULL,
      '0030114',
      211.439152,
      3,
      2,
      1,
      '134242',
      2.688959,
      ' 5- 8-1997',
      14.718559,
      NULL,
      1,
      NULL,
      0,
      0.634965,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0.334377,
      1.524107,
      NULL,
      NULL,
      0,
      0.440773,
      NULL,
      NULL,
      4.361623,
      5.347577,
      0.836134,
      1,
      5.257989,
      NULL,
      NULL,
      NULL,
      3.967595,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.680853,
      1.461843,
      0.916545,
      1.747613,
      1,
      0.079680,
      1.239933,
      NULL,
      NULL,
      NULL,
      0.454863,
      NULL,
      0,
      NULL,
      NULL,
      3.556188,
      3,
      0.553282,
      1.929728,
      1,
      7,
      1,
      0,
      3.785058,
      0,
      NULL,
      NULL,
      0.520961,
      NULL,
      NULL,
      NULL,
      1,
      0.500204,
      NULL,
      1,
      3.760083,
      0,
      0,
      NULL,
      2,
      1.728770,
      1.786758,
      1.007911,
      1.799543,
      1,
      0.708183,
      0,
      1.275775,
      1,
      NULL,
      0.327515,
      6.676906,
      NULL,
      1.872523,
      NULL,
      1,
      4,
      1.540607,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.458864,
      3,
      1,
      1,
      2,
      4,
      3.547366,
      4,
      NULL,
      1.224937,
      1.861994,
      6,
      0,
      1,
      4.709839,
      NULL,
      0.237142,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      3,
      0,
      0.402590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3,
      3,
      1.999621,
      NULL,
      NULL,
      0.374914,
      2.271619,
      0.708345,
      1.533875,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.273438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895307,
      3,
      0.189435,
      3,
      1.633642,
      2.783699,
      NULL,
      NULL,
      NULL,
      3.298500,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1.830967,
      NULL,
      1.873288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '11004',
      '',
      NULL,
      0.534924,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      2,
      0.245722,
      2,
      2,
      3.361365,
      1,
      3,
      2,
      3.140514);
commit;
end;
/


