set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '11223014',
      77,
      NULL,
      '4134340',
      NULL,
      3,
      0.701535,
      0,
      '120041',
      2,
      ' 5- 9-1995',
      20,
      33.915579,
      0,
      NULL,
      1,
      1.594154,
      0.994412,
      1,
      0,
      0.306228,
      0,
      NULL,
      NULL,
      0,
      0.417004,
      NULL,
      1.840885,
      NULL,
      0.498450,
      1.362096,
      0,
      7,
      NULL,
      1,
      NULL,
      NULL,
      8,
      1,
      NULL,
      2.942699,
      NULL,
      1.774573,
      NULL,
      NULL,
      1.524767,
      NULL,
      NULL,
      8.942254,
      1,
      1,
      3,
      0,
      3.692927,
      1,
      NULL,
      0.490067,
      NULL,
      1.109683,
      NULL,
      3,
      0,
      NULL,
      3.035675,
      0,
      2.614658,
      NULL,
      1.802430,
      NULL,
      1,
      6.014619,
      1,
      NULL,
      2.959465,
      1,
      NULL,
      NULL,
      1.272537,
      NULL,
      NULL,
      0,
      0,
      1,
      1.687136,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.624854,
      NULL,
      2.858442,
      0,
      1,
      0,
      1.251940,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.416624,
      3,
      NULL,
      6.796101,
      1.895335,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.882363,
      5.104674,
      NULL,
      NULL,
      NULL,
      0.961919,
      3.320970,
      6,
      2,
      NULL,
      NULL,
      0.620689,
      5.943150,
      1.236630,
      NULL,
      1.145852,
      1.198965,
      1.274039,
      NULL,
      0.449410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.744077,
      0,
      0,
      0.275775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.089982,
      1.829630,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.607533,
      0.234356,
      0.303431,
      NULL,
      0,
      1,
      4,
      1.914370,
      5,
      3.544743,
      0,
      2,
      1.571551,
      NULL,
      NULL,
      NULL,
      0.306985,
      2,
      0.653921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695151,
      0,
      1.745093,
      NULL,
      3,
      1.181547,
      2,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1.524561,
      1,
      NULL,
      1,
      1.877958,
      NULL,
      0.753081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      4.765537,
      1.313801,
      0.458373,
      NULL,
      1.763963,
      2.331591,
      1,
      NULL,
      2);
commit;
end;
/


