set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '02142130',
      45,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '222122',
      5,
      ' 4-20-1978',
      42.283015,
      204,
      1.576392,
      NULL,
      0.882033,
      NULL,
      2,
      1.931478,
      NULL,
      0,
      0,
      0,
      0.992742,
      0,
      1.382140,
      1.205124,
      0,
      0,
      1.303768,
      0.824992,
      NULL,
      NULL,
      0,
      2.711317,
      3.063987,
      2,
      NULL,
      NULL,
      0.715876,
      1,
      2,
      0.932027,
      NULL,
      NULL,
      1.153546,
      NULL,
      NULL,
      0.311429,
      1,
      NULL,
      3.119496,
      1,
      NULL,
      1,
      NULL,
      1,
      2,
      0.119616,
      0.262813,
      0,
      NULL,
      1,
      2.789559,
      0.168122,
      3.603407,
      NULL,
      0.054877,
      1.392841,
      1,
      6,
      0,
      NULL,
      1.001459,
      0.918738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.251119,
      1.722302,
      1,
      0.580487,
      NULL,
      1.164086,
      1.499594,
      0,
      1.575920,
      NULL,
      1.381837,
      1.152145,
      1.365966,
      1.909343,
      1.263310,
      0.605447,
      1.531099,
      NULL,
      1,
      2.425124,
      6.521081,
      6,
      1.393408,
      1,
      7.232575,
      1.954969,
      NULL,
      NULL,
      NULL,
      NULL,
      3.287247,
      NULL,
      NULL,
      NULL,
      NULL,
      2.084768,
      3.659135,
      7,
      NULL,
      6.389493,
      1,
      NULL,
      NULL,
      NULL,
      1.507822,
      3,
      3.197502,
      NULL,
      1,
      NULL,
      1.829647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.242378,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.940862,
      6.736916,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531834,
      0,
      1.355405,
      2,
      1.050655,
      2,
      3,
      2.023629,
      0,
      1,
      0,
      1,
      0.274301,
      1.204602,
      1.874805,
      1.346951,
      0,
      1.676842,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '20341',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      5,
      3,
      1,
      3.101791,
      2,
      1.328329,
      3.456468,
      0,
      2);
commit;
end;
/


