set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2001',
      '11032332',
      67,
      NULL,
      '3421300',
      59,
      NULL,
      0,
      0,
      '202333',
      1.078653,
      ' 7-23-1983',
      7,
      NULL,
      1.070729,
      NULL,
      NULL,
      1,
      3.308164,
      1,
      0.691182,
      1,
      0.132308,
      1.728333,
      0.305117,
      0.453189,
      0.718078,
      1.611636,
      0,
      0.477584,
      NULL,
      0,
      2,
      7.176111,
      3,
      NULL,
      4.233774,
      NULL,
      4,
      1,
      4.360267,
      2.739326,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.780145,
      1.175706,
      0,
      3.757301,
      NULL,
      NULL,
      0.832611,
      1,
      1.670457,
      2,
      3.830327,
      1.773951,
      0.397069,
      1.367674,
      NULL,
      NULL,
      2,
      1.928322,
      2.855144,
      NULL,
      0.158770,
      1.350144,
      2.221746,
      NULL,
      0,
      0.663593,
      1.924320,
      NULL,
      NULL,
      1.599765,
      NULL,
      NULL,
      1.600264,
      0.576838,
      1,
      0.762654,
      0,
      3.259222,
      NULL,
      0.201357,
      1.790217,
      NULL,
      1,
      0.259387,
      0.591714,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.149266,
      NULL,
      NULL,
      1.036844,
      5,
      NULL,
      2.346136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.470969,
      0.860860,
      5,
      0,
      1,
      2,
      2.613855,
      2.845232,
      NULL,
      5.158081,
      1.745479,
      0,
      0,
      3.024423,
      1,
      2,
      1.386280,
      0,
      1,
      0,
      1.851687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952308,
      NULL,
      1,
      1,
      1.950674,
      0.072806,
      0.829149,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.772187,
      1,
      2.312527,
      0,
      0.109498,
      1.028585,
      NULL,
      2.457500,
      0.758163,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.184341,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.784409,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      3.253860,
      NULL,
      1,
      0.060351,
      1,
      2.509267,
      0,
      0.833297,
      NULL,
      1.795048,
      NULL,
      0.307037,
      1,
      1,
      1.512434,
      1.724066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.711742,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.229408,
      '',
      '',
      NULL,
      2,
      NULL,
      NULL,
      2.195246,
      1,
      3,
      3,
      3,
      1);
commit;
end;
/


