set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4423',
      '20422312',
      80,
      74,
      '2420123',
      243.769054,
      1,
      3.488116,
      0,
      NULL,
      4,
      ' 4-13-2003',
      61,
      52.818953,
      1.649169,
      NULL,
      1,
      1,
      2,
      1,
      1,
      1,
      0,
      NULL,
      0.776392,
      NULL,
      NULL,
      0,
      0.851959,
      0.875865,
      0.548433,
      1,
      NULL,
      1,
      NULL,
      0.638899,
      NULL,
      4.806162,
      2.316392,
      1,
      1,
      1.737021,
      1,
      0,
      NULL,
      NULL,
      0.772720,
      NULL,
      NULL,
      NULL,
      1.399807,
      0.700189,
      3.847166,
      0.900220,
      1,
      1,
      1,
      NULL,
      1,
      3,
      1,
      2.143748,
      1.483605,
      2,
      0.106974,
      NULL,
      1,
      1.835030,
      1.805461,
      0,
      1.348475,
      7.991376,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      1.382716,
      NULL,
      NULL,
      1.739852,
      1,
      1.738700,
      NULL,
      0.435534,
      1.694314,
      1,
      0.398496,
      0.760606,
      0.134783,
      0,
      1,
      1.065683,
      2.585005,
      NULL,
      0.937210,
      0.875198,
      0,
      1,
      NULL,
      0,
      NULL,
      4,
      6,
      0.233699,
      1.037358,
      0.095892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400632,
      NULL,
      1.956937,
      1,
      4.051019,
      0,
      5,
      4.455991,
      1.357067,
      0.089315,
      NULL,
      5,
      4.270690,
      1.912791,
      NULL,
      1.673679,
      NULL,
      1.767884,
      0.378281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.002603,
      0.711098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.975069,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631241,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041565,
      NULL,
      1,
      0.483164,
      1,
      2.298010,
      0.734377,
      2.464236,
      0.519347,
      2.013531,
      1.614271,
      0,
      1.194170,
      1.424884,
      0,
      0.785230,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '44320',
      '',
      '',
      0.795257,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      3.570094,
      2,
      3.939737,
      NULL,
      1.022750,
      1,
      NULL);
commit;
end;
/


