set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4032',
      NULL,
      NULL,
      NULL,
      '2423104',
      NULL,
      3,
      3,
      2,
      '444222',
      4,
      NULL,
      0.712427,
      14,
      0,
      NULL,
      0,
      NULL,
      2.737129,
      0,
      0,
      1.282289,
      NULL,
      2.551088,
      0,
      NULL,
      1,
      1.277947,
      0,
      1.007017,
      0.296623,
      1,
      0,
      NULL,
      1,
      0.005959,
      8,
      8.287385,
      NULL,
      0,
      4,
      2,
      1,
      1,
      NULL,
      NULL,
      1.949650,
      NULL,
      NULL,
      NULL,
      0.736207,
      0.306451,
      1.800047,
      0,
      2,
      0.161727,
      1,
      0.153787,
      0.099400,
      NULL,
      0,
      0.420888,
      0,
      NULL,
      3.663065,
      1,
      0,
      0.233850,
      0,
      0.679862,
      NULL,
      3.494123,
      0,
      0,
      1,
      1.956200,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622201,
      NULL,
      1,
      0.310559,
      NULL,
      0,
      1,
      NULL,
      1.020620,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.425359,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4,
      5,
      1,
      0.082497,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749016,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.936121,
      2,
      NULL,
      0,
      2,
      NULL,
      NULL,
      7,
      1,
      3.524308,
      3.434854,
      0,
      0.149533,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736861,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.019183,
      3.624865,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.255305,
      1.650172,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.112548,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.241895,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.649027,
      1.889501,
      3.454390,
      0.681023,
      1.099118,
      0,
      NULL,
      0.459926,
      0.229911,
      1.732040,
      1,
      1.423279,
      0.478136,
      0.543162,
      1,
      1.603306,
      0,
      0,
      0.695372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '11243',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      2.939151,
      3.170801,
      2,
      NULL,
      3,
      1,
      NULL,
      0);
commit;
end;
/


