set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33031244',
      79.180807,
      14,
      '1434013',
      NULL,
      3,
      2,
      2,
      '204323',
      NULL,
      ' 1- 2-1991',
      43,
      NULL,
      0.309285,
      NULL,
      1.694419,
      0,
      0.159360,
      0.288963,
      1,
      0.333300,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.132702,
      0,
      1,
      0,
      4.955371,
      NULL,
      1,
      1.938734,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180884,
      NULL,
      NULL,
      8,
      1,
      0,
      0.651088,
      0.273722,
      1,
      NULL,
      0,
      0.905900,
      0.519513,
      1.072704,
      NULL,
      NULL,
      0,
      0,
      1,
      1.982976,
      2,
      1.609262,
      0,
      0.401986,
      1.665891,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821597,
      0.027359,
      NULL,
      NULL,
      0,
      1.572250,
      0.124086,
      1.397197,
      0.001458,
      3,
      0.165563,
      1,
      0,
      3.007165,
      1.906485,
      0.409386,
      0,
      0,
      NULL,
      NULL,
      0.236577,
      4.048003,
      0,
      9.997015,
      1,
      0,
      6.088914,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.739491,
      3,
      1.433037,
      NULL,
      6.772327,
      NULL,
      NULL,
      1.349444,
      3,
      NULL,
      11.033517,
      NULL,
      2,
      1.554742,
      5.423159,
      3,
      1.373995,
      1,
      0.437272,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882110,
      0,
      1,
      1,
      1.232033,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.105041,
      NULL,
      9,
      NULL,
      0.015648,
      1.307147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.003665,
      1.698717,
      NULL,
      1,
      2,
      1.352135,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.864681,
      0.383535,
      NULL,
      1.860455,
      NULL,
      1.488259,
      0,
      0,
      3,
      1,
      0.995871,
      0.515901,
      1,
      0.300146,
      NULL,
      0.706309,
      0,
      1,
      0.631722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '20332',
      '',
      '',
      1,
      '',
      '',
      '',
      0.515528,
      '',
      '',
      '',
      4,
      1.492539,
      3,
      NULL,
      NULL,
      1.515621,
      1.532980,
      3,
      1.713295);
commit;
end;
/


