set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '3013131',
      6.871785,
      3,
      1.513283,
      1,
      '322141',
      3,
      ' 6-24-1986',
      4.456950,
      NULL,
      0,
      NULL,
      3.175929,
      1.759919,
      3,
      0,
      0,
      0,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.838507,
      0,
      NULL,
      3,
      1.125605,
      0.094353,
      3,
      NULL,
      6,
      NULL,
      1.670354,
      1,
      0,
      0.856980,
      NULL,
      NULL,
      1.350355,
      NULL,
      NULL,
      3.675940,
      1.589766,
      0.789488,
      2.457188,
      NULL,
      0,
      1.494873,
      1,
      2.841321,
      0,
      3,
      2,
      0.373364,
      3.385837,
      NULL,
      0.606253,
      NULL,
      1.593404,
      1.626850,
      7.815049,
      NULL,
      1.003949,
      NULL,
      0,
      NULL,
      2.814329,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.692619,
      1.870396,
      NULL,
      0.066160,
      NULL,
      NULL,
      1,
      NULL,
      0.292377,
      1.622436,
      NULL,
      1,
      0,
      0.426774,
      NULL,
      0.380235,
      0,
      1.645729,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0.896470,
      0.200549,
      1.883309,
      0.340268,
      0.203865,
      0,
      0,
      1.706233,
      0,
      2.244027,
      NULL,
      4.324717,
      1,
      3,
      4,
      8.760816,
      7.470502,
      1,
      1,
      0.160125,
      NULL,
      1,
      0.922922,
      NULL,
      1.920292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.913712,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599109,
      0.581888,
      0,
      0,
      NULL,
      0,
      1.476786,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.612197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558536,
      NULL,
      NULL,
      0,
      1.204267,
      1,
      1.274393,
      1,
      NULL,
      3,
      0,
      0,
      NULL,
      1.681786,
      0.575725,
      1,
      0.190217,
      0,
      1.273212,
      1.206925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.162199,
      '40300',
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      1.063587,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


