set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20121224',
      50,
      48,
      '0334234',
      7.935348,
      3,
      NULL,
      0,
      '332113',
      1,
      ' 5-25-1978',
      32.371838,
      43,
      1.185283,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      2.850450,
      0.008749,
      0.866536,
      1.548887,
      NULL,
      3,
      0,
      0,
      NULL,
      1.643190,
      1,
      NULL,
      1,
      NULL,
      0.955388,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879482,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.229802,
      0.961392,
      5.865027,
      0,
      1.607147,
      1.054080,
      0,
      0,
      1.722533,
      0.771440,
      0,
      NULL,
      NULL,
      0,
      0,
      0.547940,
      1.610004,
      0.370778,
      0,
      NULL,
      0,
      5.457711,
      0,
      1,
      NULL,
      NULL,
      4.348080,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      5,
      1.862048,
      3.994007,
      3.927772,
      NULL,
      NULL,
      0,
      5,
      NULL,
      7,
      10,
      5,
      NULL,
      1.567493,
      0.032232,
      NULL,
      NULL,
      0.326886,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274097,
      NULL,
      0,
      1,
      0,
      NULL,
      2.791528,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.073584,
      NULL,
      NULL,
      NULL,
      NULL,
      2.444028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177793,
      7.659674,
      3,
      0.157133,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.147687,
      1,
      0.458243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      3.989466,
      0.033050,
      1,
      1.194016,
      1,
      1.158779,
      NULL,
      1.356548,
      1.843656,
      0,
      1,
      0.172669,
      0.113934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.570353,
      '42330',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.554226,
      NULL,
      3.274013,
      1.161153,
      2,
      0,
      NULL,
      NULL,
      NULL);
commit;
end;
/


