set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      74.263949,
      37.579351,
      NULL,
      109,
      5,
      2,
      0,
      '231033',
      3.259154,
      ' 8- 6-1977',
      NULL,
      NULL,
      1.366592,
      NULL,
      0.003978,
      1,
      1,
      NULL,
      1,
      0.669329,
      0.038760,
      1.417956,
      1.928240,
      1.263401,
      5,
      1,
      0,
      0,
      1.200379,
      1,
      3,
      3.946139,
      NULL,
      2.171308,
      0.250398,
      NULL,
      5.295654,
      1,
      NULL,
      3,
      1.185195,
      1.112238,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.237142,
      1,
      2.782740,
      1,
      NULL,
      0.657000,
      3,
      2.516497,
      3,
      2,
      1,
      1.692400,
      3.983597,
      1,
      NULL,
      3,
      1,
      NULL,
      7.262912,
      1.353733,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.320070,
      0.275930,
      6,
      6,
      NULL,
      1,
      0,
      NULL,
      1,
      1.059203,
      3,
      1.276318,
      1.886901,
      0,
      1.273804,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.746547,
      3,
      3.103201,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      5.695531,
      2,
      6,
      8,
      6,
      4,
      NULL,
      7.542966,
      NULL,
      0,
      5.939267,
      2.507498,
      1.621224,
      1,
      0.004902,
      6.516587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.717533,
      NULL,
      NULL,
      0,
      0,
      1,
      1.602813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470092,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.849243,
      1,
      3,
      3,
      3.477519,
      4.474566,
      1.726976,
      NULL,
      7,
      NULL,
      2,
      1.123903,
      NULL,
      NULL,
      NULL,
      0.141549,
      1.140086,
      1.013526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.802493,
      NULL,
      2,
      3,
      2,
      1.654144,
      1,
      2.323942,
      NULL,
      0,
      NULL,
      0.694824,
      1,
      1,
      1,
      1,
      NULL,
      0.421475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      0.302085,
      '',
      '',
      '',
      1.395033,
      NULL,
      NULL,
      '',
      1,
      4,
      3.490536,
      3.071162,
      1,
      7,
      NULL,
      2,
      NULL);
commit;
end;
/


