set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '324',
      NULL,
      37.880997,
      10.772336,
      '2144004',
      6.715577,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      35.123655,
      0.718647,
      NULL,
      3,
      1,
      2.718938,
      0,
      0.016252,
      1.078138,
      0,
      0.105569,
      2.714635,
      NULL,
      0,
      0.942656,
      0.603427,
      1.785913,
      0.793025,
      1,
      1.734903,
      0.421447,
      0,
      3.906967,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      3.408548,
      0,
      0.842098,
      1,
      1.644384,
      1.138250,
      0,
      1.191364,
      2.205664,
      1.522103,
      0.974006,
      3.743595,
      3.419098,
      NULL,
      0.605808,
      2.496595,
      NULL,
      0.363719,
      1,
      1,
      3.483602,
      1,
      0,
      2.810015,
      1.528524,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.597301,
      NULL,
      1,
      1.445436,
      0.151071,
      0.826329,
      NULL,
      NULL,
      1.745603,
      1,
      1,
      0.214319,
      1,
      0,
      0,
      0,
      1,
      0.809663,
      NULL,
      0.185775,
      11,
      0,
      1.929433,
      1.222332,
      NULL,
      1.371204,
      0.035106,
      4.855944,
      0,
      5.112081,
      4,
      5,
      5.702081,
      3,
      1.824845,
      4.009951,
      5.215542,
      NULL,
      7.903978,
      4,
      2,
      NULL,
      8,
      NULL,
      1,
      NULL,
      5,
      0.161321,
      0.473369,
      1.965634,
      4,
      1.285413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.588176,
      1,
      1,
      NULL,
      1.944128,
      1.233741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      5,
      2.653128,
      0.896251,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      2.128169,
      3.718597,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.894357,
      1.721270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.196343,
      3,
      3.319788,
      1.967552,
      0.616646,
      1.003287,
      1,
      0.360762,
      NULL,
      1.768588,
      0.720705,
      0.847631,
      1,
      NULL,
      1.635561,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '40214',
      '20041',
      '',
      0.331018,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


