set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      NULL,
      NULL,
      21,
      '4203011',
      9,
      NULL,
      2.687691,
      1,
      NULL,
      4.728699,
      ' 9-13-1981',
      114,
      52,
      1.563474,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      NULL,
      1.008780,
      1.050780,
      2.295689,
      0.253556,
      0.635777,
      1.726280,
      NULL,
      1,
      1,
      NULL,
      1,
      1.245175,
      0,
      1,
      0,
      0.346542,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      0.775776,
      1.851170,
      1,
      NULL,
      NULL,
      3.249824,
      1,
      1.561101,
      3.456091,
      NULL,
      0.183645,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      1.943633,
      0,
      2,
      1.992139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933194,
      1,
      1.835477,
      0.254087,
      NULL,
      1.406300,
      0,
      1,
      1.599692,
      1.654934,
      1.686946,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1.850371,
      7.458411,
      1.484677,
      1,
      1,
      0,
      7.863088,
      1,
      6.275492,
      0,
      9.948430,
      NULL,
      7.307713,
      7,
      NULL,
      1,
      5.140736,
      6.069099,
      11,
      1.552498,
      3.906576,
      3.697207,
      9.977778,
      5,
      9,
      NULL,
      0,
      2.752707,
      3.104182,
      1.902170,
      0.400202,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386830,
      0.431655,
      0,
      1,
      0,
      1.669169,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511319,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      7,
      1.091554,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.290532,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617259,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      2.266371,
      1,
      2,
      2,
      1.200695,
      NULL,
      1.973769,
      1.443260,
      1,
      NULL,
      1.719062,
      1.249922,
      NULL,
      1.473544,
      NULL,
      0.147936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.580266,
      '10032',
      '03211',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.645913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


