set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12',
      47.852745,
      17,
      '0202433',
      NULL,
      1,
      0.856244,
      3,
      '330424',
      4.626727,
      ' 2- 0-2000',
      170.673466,
      114.394481,
      NULL,
      NULL,
      0,
      0.395910,
      0,
      1.062001,
      1.618913,
      NULL,
      NULL,
      3,
      0.688855,
      1,
      0.145159,
      0,
      0.871712,
      1.678460,
      NULL,
      0.340195,
      1.404103,
      1,
      1,
      1.502022,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.418644,
      1.906950,
      1,
      1,
      1.897399,
      0,
      NULL,
      NULL,
      3,
      0.890262,
      3.921663,
      1.432566,
      0,
      0.518985,
      1,
      0.677090,
      3.211186,
      1.625960,
      2.868636,
      0,
      1.498558,
      0,
      3,
      NULL,
      0,
      NULL,
      1.780245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.527581,
      1,
      0,
      1,
      3,
      NULL,
      1.298086,
      1.055119,
      0.711785,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.414023,
      0,
      0,
      0.051179,
      NULL,
      0.086481,
      4,
      0,
      1,
      1,
      0.706844,
      NULL,
      NULL,
      7,
      1,
      7,
      NULL,
      3,
      1.130684,
      9,
      1.966908,
      2,
      0.335708,
      9.472604,
      2.192558,
      6,
      3.113281,
      2,
      NULL,
      8,
      5.481615,
      NULL,
      4,
      3.202178,
      1,
      1.317454,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.766766,
      1,
      1,
      1,
      1.215759,
      0.468378,
      1.465201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057145,
      NULL,
      NULL,
      NULL,
      NULL,
      3.535011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0.213933,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731316,
      4,
      NULL,
      2.976656,
      NULL,
      0.098547,
      NULL,
      NULL,
      NULL,
      0.029249,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368420,
      0,
      3,
      1,
      NULL,
      1,
      NULL,
      1.724227,
      0,
      1,
      2,
      1,
      1.944951,
      1,
      0.632996,
      1,
      1,
      NULL,
      1.448306,
      1.931193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42110',
      '33112',
      '',
      0,
      '',
      NULL,
      '',
      0.128449,
      '',
      '',
      '',
      3.733574,
      5,
      0,
      0.002683,
      NULL,
      NULL,
      2,
      1,
      NULL);
commit;
end;
/


