set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '24011331',
      32,
      7,
      NULL,
      NULL,
      0,
      0,
      3,
      '202310',
      2,
      ' 7-29-1984',
      130.866365,
      121.808790,
      1,
      NULL,
      16.389865,
      0,
      3,
      0.764676,
      0.251153,
      0,
      1.772298,
      0,
      3.217202,
      1,
      0,
      1,
      NULL,
      1,
      0.697206,
      1.837391,
      0,
      1.708760,
      0,
      1,
      0.044529,
      0.254185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.582819,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858024,
      0,
      1.826666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.732945,
      0.559281,
      1,
      NULL,
      0,
      NULL,
      1.994176,
      0,
      NULL,
      1.386226,
      1,
      1.088075,
      0.386822,
      NULL,
      1.981069,
      0,
      NULL,
      1,
      2.331214,
      1.236156,
      1,
      2.050301,
      NULL,
      7.731015,
      1.642534,
      6.047967,
      3.782780,
      NULL,
      NULL,
      3.785392,
      5,
      3.745919,
      0.609556,
      NULL,
      1.157439,
      NULL,
      1,
      0,
      1,
      0.854340,
      3.062701,
      NULL,
      NULL,
      0.451126,
      3.439135,
      NULL,
      NULL,
      NULL,
      6,
      1.992780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255388,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.434889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615136,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.006395,
      0.014287,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261951,
      0.708071,
      1.806351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818059,
      1.590468,
      0.423291,
      NULL,
      0,
      0,
      1.855060,
      0,
      1,
      0,
      1.333820,
      0.619523,
      0.176817,
      1.949668,
      NULL,
      1.604000,
      1,
      0,
      0.535359,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '02111',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      3,
      2.334408,
      NULL,
      0,
      1.303218,
      NULL,
      1.564342);
commit;
end;
/


