set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      '21023414',
      61.099093,
      16.222248,
      '0130313',
      NULL,
      3,
      0.559709,
      2,
      '404013',
      1,
      ' 2-11-1984',
      162.993470,
      NULL,
      NULL,
      NULL,
      4,
      1.987873,
      1,
      0,
      0,
      2,
      1,
      0.403930,
      1,
      0.524025,
      NULL,
      0.018641,
      NULL,
      1.354749,
      NULL,
      NULL,
      NULL,
      1.692625,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4,
      8,
      NULL,
      NULL,
      0.535095,
      0.598239,
      0,
      0.546352,
      0.391201,
      0.662752,
      0.428863,
      0.179118,
      0,
      NULL,
      2.451621,
      1.359280,
      2,
      NULL,
      1.704679,
      0,
      2.807970,
      9.711176,
      1,
      0,
      3.742768,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.727263,
      4.916193,
      1.379211,
      1.213600,
      1,
      NULL,
      1.679192,
      5,
      0.447921,
      2.053705,
      0.091880,
      0,
      1.683651,
      NULL,
      0.667841,
      NULL,
      0,
      4,
      3.560788,
      NULL,
      6.003335,
      NULL,
      9,
      1,
      9.649244,
      3.610731,
      5,
      9,
      4.736407,
      NULL,
      6.387730,
      1,
      8.394378,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.760578,
      1,
      0.751737,
      NULL,
      NULL,
      1.793635,
      6,
      1.544256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684766,
      1,
      0,
      0,
      0.590785,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357316,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      7.815353,
      5.219644,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.882112,
      2.681880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406576,
      NULL,
      0.650340,
      2,
      0.825529,
      NULL,
      NULL,
      0,
      2,
      3,
      0.347651,
      NULL,
      1,
      NULL,
      1.623321,
      0,
      1.605591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2,
      2,
      0,
      NULL,
      0.782536,
      3,
      0.579555,
      0,
      1.190614);
commit;
end;
/


