set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20223203',
      NULL,
      69,
      '4424431',
      29,
      3,
      NULL,
      1,
      '021244',
      2.679701,
      ' 0-25-1977',
      160,
      128.013961,
      0.747864,
      NULL,
      0.628771,
      0,
      2,
      NULL,
      1.050537,
      0.853451,
      NULL,
      1,
      0.047875,
      NULL,
      1.312238,
      0.506860,
      0,
      1.319298,
      1.572269,
      0.434994,
      0,
      0.260293,
      0.919525,
      1,
      1.068185,
      0.173468,
      1.253409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.616418,
      4.976488,
      5,
      2.570688,
      1,
      3,
      NULL,
      0,
      1.638268,
      1,
      1,
      NULL,
      1.653665,
      1,
      3.729111,
      NULL,
      0,
      3,
      NULL,
      0.623667,
      0.231771,
      4,
      NULL,
      1,
      2,
      NULL,
      0.612418,
      NULL,
      NULL,
      0.958288,
      NULL,
      NULL,
      NULL,
      0.443250,
      1,
      3.278692,
      1.720720,
      3.314089,
      0.533400,
      0.692333,
      0,
      0,
      NULL,
      1.131944,
      NULL,
      1.541350,
      1.370233,
      1,
      1.653554,
      0,
      1.963820,
      NULL,
      NULL,
      7,
      3,
      0,
      NULL,
      0.851273,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133973,
      2.646046,
      2.639402,
      0,
      7,
      9.637696,
      8,
      5.980099,
      9,
      11.621802,
      6.550175,
      10.902422,
      0.594759,
      0,
      0.293158,
      3.703934,
      2.944680,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913231,
      1.340333,
      0,
      NULL,
      0,
      NULL,
      1,
      0.621967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586568,
      NULL,
      NULL,
      0,
      NULL,
      1.404019,
      NULL,
      NULL,
      NULL,
      NULL,
      2.952444,
      0.894938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453481,
      1.956399,
      NULL,
      0,
      1,
      1,
      0,
      3,
      3,
      NULL,
      2.013283,
      0.741939,
      1,
      1.799579,
      0,
      NULL,
      NULL,
      0,
      1.048509,
      1.501920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42000',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.986649,
      '',
      '',
      '',
      5,
      3,
      1.655243,
      1,
      3,
      0,
      3.706105,
      1.750753,
      2);
commit;
end;
/


