set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      '12004203',
      NULL,
      48,
      '0133312',
      83,
      1,
      0.029585,
      2,
      '101410',
      3.551970,
      ' 7-29-1996',
      NULL,
      NULL,
      1.726689,
      NULL,
      1.257948,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      4.138931,
      0,
      0,
      1,
      0.165174,
      2,
      3,
      1,
      NULL,
      1.316742,
      0.675606,
      0,
      1.904336,
      1,
      0,
      2.550753,
      0.879897,
      1.983974,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      1.263541,
      7,
      0,
      0,
      0.721221,
      3.372742,
      1.641080,
      1.672717,
      2.899159,
      NULL,
      1,
      2.684269,
      0,
      1.532954,
      0,
      3,
      1,
      1,
      8,
      NULL,
      2,
      7.867393,
      0,
      1,
      NULL,
      1.147026,
      NULL,
      NULL,
      1.886389,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      3.839131,
      4.259949,
      3.593154,
      0,
      1,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.252562,
      1.286818,
      4,
      0.022796,
      7,
      NULL,
      9,
      9,
      NULL,
      2.154040,
      5.933092,
      7.464539,
      NULL,
      1,
      0,
      1,
      6.004712,
      6,
      NULL,
      5,
      10.573481,
      11.479453,
      9.691474,
      NULL,
      NULL,
      0,
      1,
      1,
      0.823131,
      4,
      0.786795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.157660,
      1.810668,
      3,
      1,
      0,
      2,
      1.159040,
      NULL,
      NULL,
      NULL,
      NULL,
      7.517256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.145058,
      2,
      1,
      3.323820,
      NULL,
      3,
      3,
      NULL,
      0.684572,
      0.526145,
      3.009271,
      1.681828,
      0,
      1,
      0,
      1.126603,
      0.350377,
      0.532021,
      1.074120,
      0.557094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.987547,
      '32223',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      1,
      0.300758,
      2.923944,
      2.135623,
      5.477425,
      1.726403,
      1,
      2,
      3.353800);
commit;
end;
/


