set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '41021304',
      NULL,
      7.447756,
      '2023231',
      NULL,
      0,
      0,
      2,
      '243041',
      0,
      ' 7-20-1989',
      102,
      127.749110,
      1,
      NULL,
      1.247619,
      1,
      0,
      1,
      1.769265,
      1,
      0,
      3.340275,
      3,
      0.085601,
      5,
      1,
      1.260901,
      0,
      0.514549,
      2.768879,
      4.565940,
      1,
      NULL,
      7,
      2,
      0.500734,
      5,
      0,
      4,
      4.696688,
      2,
      0,
      NULL,
      NULL,
      1.577972,
      NULL,
      NULL,
      NULL,
      2.327558,
      4.082425,
      0.423197,
      0.547878,
      1.819665,
      2.462822,
      3,
      0.894129,
      1,
      3,
      NULL,
      3.163175,
      2,
      0,
      NULL,
      3,
      2,
      1.253587,
      0,
      NULL,
      0,
      4.978867,
      1,
      0,
      1.407081,
      NULL,
      NULL,
      NULL,
      1.968021,
      NULL,
      NULL,
      NULL,
      0.111587,
      1,
      2.928022,
      5.328879,
      3.853684,
      NULL,
      0.869258,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.529528,
      1.286014,
      0.450049,
      0,
      0.759015,
      NULL,
      0,
      0,
      5,
      0,
      3.170370,
      0.929400,
      9,
      1.643396,
      NULL,
      NULL,
      NULL,
      NULL,
      4.794846,
      3.641084,
      NULL,
      0.704157,
      NULL,
      1,
      4.691550,
      0,
      8,
      NULL,
      NULL,
      5,
      3,
      1,
      1.412988,
      NULL,
      3.953530,
      0.538677,
      NULL,
      6.375187,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1.275641,
      0,
      NULL,
      0.308156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.561235,
      NULL,
      NULL,
      NULL,
      1.718429,
      1,
      9.830128,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.315565,
      NULL,
      0.193958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      1,
      1,
      3,
      3,
      NULL,
      NULL,
      0.784136,
      1.130435,
      1,
      1,
      1.967128,
      0.293360,
      0,
      1.408009,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '13232',
      '12443',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      4.582509,
      NULL,
      3.562881,
      1,
      1.873961,
      1,
      2.385661,
      1,
      0.534592);
commit;
end;
/


