set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '14301041',
      11,
      44,
      '4100111',
      17.729582,
      6,
      0,
      0,
      '420314',
      0.485966,
      '10- 8-1983',
      18,
      35.034736,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0.681286,
      NULL,
      0.668920,
      3,
      1.154218,
      1.131207,
      NULL,
      0,
      NULL,
      1,
      0.847042,
      0,
      3,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      4,
      2,
      1.829454,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.694585,
      6.313042,
      NULL,
      2.745860,
      0.773688,
      0,
      2,
      2.698190,
      2.215362,
      1,
      1,
      1,
      3,
      1,
      0.242624,
      2,
      NULL,
      3,
      2.801801,
      0,
      0.937540,
      1,
      5.764040,
      0,
      0,
      NULL,
      1.888643,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897204,
      NULL,
      1.086704,
      1,
      1,
      0,
      0.823569,
      0,
      NULL,
      1.009119,
      NULL,
      1,
      0.570916,
      0.541047,
      1,
      1.680536,
      NULL,
      1,
      3,
      1.933068,
      5,
      NULL,
      1,
      1,
      NULL,
      3.234747,
      3,
      5,
      4,
      NULL,
      4.762210,
      3.712525,
      NULL,
      3,
      7,
      NULL,
      3.621127,
      NULL,
      7,
      NULL,
      9.523879,
      4,
      1.629804,
      NULL,
      NULL,
      2.864775,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.009740,
      NULL,
      0,
      0,
      0.099820,
      5.051910,
      0.704165,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110912,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.108675,
      1.744098,
      0.434376,
      NULL,
      1.126756,
      2,
      3.588869,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883523,
      9.125533,
      7,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.837912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.016267,
      2.428191,
      NULL,
      0.180832,
      3,
      0,
      3.848031,
      0.609335,
      1,
      0.730899,
      0.617256,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1.945192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01440',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.946738,
      '',
      '',
      '',
      4,
      0,
      NULL,
      3.088078,
      NULL,
      3,
      1.746252,
      3,
      0);
commit;
end;
/


