set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2440',
      '10443424',
      17,
      45,
      '0112123',
      155.055305,
      2,
      2.349131,
      2,
      NULL,
      1.545816,
      ' 3-20-1990',
      44.611315,
      209.068928,
      0,
      NULL,
      NULL,
      1.100712,
      1,
      NULL,
      1.822555,
      NULL,
      1.411406,
      1.202626,
      0.061751,
      1.203790,
      5,
      1,
      NULL,
      1,
      NULL,
      4.380579,
      2,
      NULL,
      1.114983,
      2,
      0,
      0,
      NULL,
      0,
      5,
      NULL,
      2,
      0.250746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.344637,
      3.033922,
      0.840831,
      0.723880,
      NULL,
      0.593412,
      1.919067,
      2,
      3.709948,
      1,
      2.210357,
      2.846436,
      3.707981,
      NULL,
      2.005033,
      NULL,
      2,
      0,
      1.396917,
      0.475180,
      10,
      0,
      NULL,
      0.378071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924869,
      NULL,
      0.728116,
      NULL,
      NULL,
      NULL,
      3.625234,
      0.456962,
      1,
      0.309092,
      0,
      1,
      0,
      6.083736,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.655956,
      4.555913,
      0,
      1.620462,
      2.863447,
      0.131731,
      3.645433,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583023,
      2.263049,
      6.292355,
      0.499392,
      NULL,
      NULL,
      5.803668,
      1,
      NULL,
      2.790062,
      4.578882,
      3,
      3,
      NULL,
      0.540982,
      NULL,
      2.782385,
      1.537029,
      1.304450,
      NULL,
      0.132629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.570487,
      1,
      0,
      1,
      NULL,
      1,
      0.881187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241608,
      3,
      4.345936,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680970,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612741,
      3.744272,
      1,
      NULL,
      1.877189,
      1,
      1,
      3.919369,
      1.562017,
      1,
      3.702039,
      0,
      1,
      0.463732,
      0.199922,
      1.094441,
      NULL,
      1,
      0.035807,
      1.990139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.478388,
      '32031',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1.387779,
      '',
      '',
      '',
      1,
      0.234837,
      0.660613,
      3.880365,
      NULL,
      NULL,
      3,
      1.981770,
      NULL);
commit;
end;
/


