set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2414',
      '14332004',
      67,
      38,
      '2340444',
      NULL,
      5,
      2.255226,
      NULL,
      '133330',
      NULL,
      ' 6-26-2002',
      NULL,
      138.854026,
      1,
      NULL,
      1.349601,
      1,
      2,
      1.528128,
      NULL,
      NULL,
      1.880582,
      0.374512,
      0.686735,
      0.288940,
      0.390471,
      0,
      1.609472,
      1.653711,
      1.097170,
      0.593133,
      7,
      0,
      NULL,
      0,
      1.068606,
      NULL,
      4,
      0,
      5.437313,
      3.228756,
      NULL,
      0.048075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.175090,
      0.160744,
      0.602226,
      0.542787,
      0,
      3,
      1,
      1,
      0,
      3.890824,
      1.851267,
      1.144908,
      0,
      3.135907,
      2.689471,
      1,
      0,
      1.888594,
      5,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      3,
      1.405018,
      0.133362,
      1.607185,
      0,
      0.417909,
      1,
      0.460894,
      NULL,
      0.968223,
      1.153429,
      1.296389,
      1,
      0,
      NULL,
      0.010373,
      4,
      0,
      NULL,
      4,
      1.778532,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      5.916010,
      1,
      3,
      NULL,
      2.153006,
      0,
      1.353859,
      3.021533,
      2,
      3,
      1.250652,
      1.834776,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1.997487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.296790,
      1.291702,
      7.313746,
      3.117300,
      1.333681,
      1,
      1.351212,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.169651,
      2.545216,
      1.388810,
      0.008542,
      2.766026,
      1,
      1,
      2.895175,
      2.476613,
      1.669877,
      1,
      0.580645,
      NULL,
      1.706588,
      0.771777,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '41004',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      0,
      0,
      3,
      2.546089,
      2.333478,
      0,
      0,
      1);
commit;
end;
/


