set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3130',
      NULL,
      NULL,
      76.091600,
      '3241323',
      167.783331,
      4,
      0.410642,
      0,
      NULL,
      NULL,
      ' 2-19-1990',
      0,
      27.593629,
      1.045541,
      NULL,
      NULL,
      1,
      1.054502,
      NULL,
      1,
      0.867337,
      0.226302,
      3.372632,
      0,
      0.936599,
      6,
      NULL,
      1,
      NULL,
      1.546445,
      NULL,
      NULL,
      0.571331,
      NULL,
      0,
      1.220169,
      0.337559,
      6,
      1,
      0,
      2,
      3,
      0.512942,
      NULL,
      NULL,
      1.080898,
      NULL,
      NULL,
      6,
      NULL,
      1,
      2,
      0,
      0.668350,
      1,
      NULL,
      1.589178,
      NULL,
      NULL,
      0.843238,
      1,
      1.420064,
      2.922135,
      2.012184,
      0.641667,
      0,
      0.232436,
      NULL,
      1,
      3.256940,
      NULL,
      0,
      NULL,
      2,
      0.143624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.311362,
      0,
      0.915790,
      1,
      NULL,
      0,
      0.905740,
      1,
      1.162543,
      NULL,
      0,
      NULL,
      5.719624,
      0.632665,
      NULL,
      1.358063,
      0,
      NULL,
      NULL,
      1,
      5.962890,
      1,
      3.104309,
      2.410865,
      0.114048,
      1,
      3.170561,
      NULL,
      NULL,
      NULL,
      NULL,
      2.258271,
      1,
      2,
      1,
      5,
      3.521932,
      NULL,
      6.936093,
      2.418732,
      0.148320,
      4,
      2,
      7.624399,
      1.298873,
      NULL,
      0.054387,
      1.489282,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.345489,
      1.190174,
      1.455340,
      1.022132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206146,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.726521,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.600916,
      3.837850,
      1,
      NULL,
      1,
      0,
      2.290363,
      0.702176,
      0,
      0.792505,
      0,
      0,
      0,
      0.104042,
      0.643747,
      1.950053,
      0,
      1,
      NULL,
      1.021660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '43200',
      '',
      1.780227,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      4,
      0.932520,
      1.714832,
      1.484126,
      3.299595,
      0,
      2.661843,
      2.274906,
      2);
commit;
end;
/


