set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1242',
      '02143414',
      74,
      75.511020,
      '4424212',
      54.426138,
      4,
      2.286737,
      3,
      '442130',
      0,
      ' 4-27-1974',
      192,
      20.579623,
      NULL,
      NULL,
      0.771047,
      1,
      0.042368,
      1,
      1,
      0.878724,
      0,
      3,
      0,
      1.599119,
      NULL,
      0.609995,
      0,
      NULL,
      NULL,
      1.214726,
      0.862132,
      NULL,
      0.012738,
      2,
      0.452623,
      0.616426,
      4,
      0,
      NULL,
      3,
      3,
      0.889004,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      4,
      3.139082,
      1,
      0,
      NULL,
      2.486826,
      NULL,
      2,
      0.866182,
      3.654266,
      1.223945,
      1.482346,
      0,
      0,
      1.050046,
      2.241811,
      1,
      1.134716,
      0.965416,
      0.155909,
      2.590417,
      1,
      1,
      NULL,
      2.684264,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.562755,
      1.953703,
      1,
      1.258900,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.841822,
      0,
      1,
      5.504812,
      1.837543,
      0,
      0.628309,
      0.482035,
      NULL,
      NULL,
      1.217995,
      1.712065,
      0,
      NULL,
      NULL,
      0.022306,
      7,
      1.503126,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      9.492181,
      1,
      NULL,
      1,
      2.944088,
      4.909738,
      4,
      NULL,
      2.955986,
      NULL,
      0.042344,
      1.968100,
      1.168529,
      0.230965,
      2.674752,
      0,
      1.426469,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.203846,
      0,
      1,
      1,
      1,
      NULL,
      0.553914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534936,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.689339,
      3.623703,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.021506,
      1.576134,
      NULL,
      0.968243,
      NULL,
      NULL,
      NULL,
      1.678090,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343261,
      2,
      1,
      0.217554,
      2.437355,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398012,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.406819,
      '40210',
      '31243',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1.875192,
      NULL,
      1.357055,
      3.675951,
      NULL,
      NULL,
      NULL,
      2.742014,
      NULL);
commit;
end;
/


