set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '11414343',
      17,
      NULL,
      '3014410',
      159.012335,
      1,
      3.638618,
      3,
      '424102',
      NULL,
      NULL,
      16.308615,
      4.809946,
      1,
      NULL,
      0,
      0,
      1.126990,
      0,
      1.295044,
      0,
      NULL,
      3.330385,
      1.741073,
      1,
      0.968022,
      1.443602,
      NULL,
      1.795271,
      1.812572,
      0,
      NULL,
      0,
      1.902988,
      0.593814,
      0,
      0.798192,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545684,
      1.830514,
      1,
      1.297655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489648,
      1,
      0,
      1.343829,
      NULL,
      0,
      1.487854,
      1,
      0,
      1,
      1.878123,
      NULL,
      1,
      1.617357,
      1,
      0.861313,
      1,
      0,
      1.010862,
      NULL,
      NULL,
      NULL,
      0.701966,
      0,
      0.589803,
      0.838578,
      1,
      1.661658,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677347,
      0.722949,
      0.480832,
      1.824409,
      0.779757,
      0,
      NULL,
      NULL,
      9.017305,
      NULL,
      NULL,
      11,
      3,
      1,
      0,
      NULL,
      1.931743,
      NULL,
      NULL,
      5.732864,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.726778,
      NULL,
      0,
      0.517235,
      NULL,
      1.360783,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.883565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.973126,
      1.253208,
      1.875977,
      0.339524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.361026,
      0.545615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910037,
      0.024805,
      0,
      0,
      0.353983,
      0.933067,
      NULL,
      1,
      1.711405,
      0,
      1,
      1.936019,
      0,
      1.991101,
      NULL,
      1,
      NULL,
      1.604136,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.200040,
      '',
      NULL,
      '',
      0,
      '2122',
      '',
      '',
      NULL,
      '02202',
      '',
      '',
      5,
      1,
      1,
      NULL,
      3.309539,
      NULL,
      0,
      NULL,
      NULL);
commit;
end;
/


