set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '202',
      '32322144',
      32,
      59.711417,
      '3144222',
      NULL,
      5,
      3.993641,
      0,
      NULL,
      1.375193,
      ' 3-25-1997',
      57,
      43.595664,
      NULL,
      NULL,
      NULL,
      1.830132,
      1,
      1,
      1.776912,
      NULL,
      1,
      1.594015,
      0.639015,
      0.010985,
      NULL,
      NULL,
      1.796621,
      NULL,
      NULL,
      1.043652,
      NULL,
      1,
      1,
      0.820123,
      0.786813,
      0.189160,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761609,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.599834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.963031,
      0.977187,
      1.725597,
      0.423165,
      1,
      1.764409,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.325357,
      1.682320,
      0,
      1,
      NULL,
      0,
      0.076580,
      0.369103,
      2,
      1.774176,
      1,
      0.110766,
      2.973082,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.549010,
      0,
      NULL,
      9.932302,
      6.524288,
      1,
      9,
      NULL,
      0.329795,
      3.743629,
      0.543271,
      0.535260,
      1,
      1,
      NULL,
      NULL,
      9.606773,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759062,
      0.502020,
      2,
      1,
      0.302708,
      0.345448,
      0.701095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184905,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.299970,
      3,
      1.218793,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      1,
      1,
      NULL,
      0.410118,
      NULL,
      NULL,
      NULL,
      1.779294,
      0,
      0.420467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812334,
      0.814554,
      0.528216,
      1,
      1.641592,
      1,
      3.115592,
      0.538070,
      1.298030,
      1.724306,
      0.807779,
      0,
      1,
      0.556286,
      0.333823,
      NULL,
      1.285672,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '',
      '',
      0,
      '3022',
      '',
      '',
      1,
      '41424',
      NULL,
      '',
      0.199785,
      2.195952,
      1,
      1,
      NULL,
      0.203663,
      2.813950,
      3.204664,
      2);
commit;
end;
/


