set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3210',
      NULL,
      NULL,
      83.272691,
      '1033334',
      106,
      2,
      2.310338,
      2,
      '403032',
      4,
      ' 4-28-1992',
      65.178601,
      11.525652,
      0,
      NULL,
      1,
      1,
      2.265069,
      1,
      1.647584,
      1.761244,
      1.135532,
      3.807826,
      0.126529,
      0,
      0.633626,
      0,
      1,
      0.894806,
      0.521938,
      0,
      1.767627,
      NULL,
      1,
      1,
      1.280237,
      NULL,
      0.661137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939382,
      0.587597,
      0.932681,
      0.103646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.796562,
      0.661838,
      0,
      1,
      1.718225,
      1.539169,
      1,
      0.810868,
      1.126499,
      0,
      0,
      1,
      0.868577,
      1,
      0.396116,
      1.596330,
      NULL,
      0,
      NULL,
      1.954470,
      NULL,
      NULL,
      1,
      1.906711,
      0.617342,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049593,
      1.086248,
      0.609742,
      3,
      1.443331,
      6,
      NULL,
      NULL,
      NULL,
      9.579847,
      0.713178,
      7.782140,
      9,
      1.141828,
      1.001392,
      1.576811,
      1,
      NULL,
      NULL,
      9.226713,
      1.438610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713672,
      1,
      0,
      1,
      NULL,
      0.640342,
      0.657024,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934079,
      1,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.456582,
      1,
      1.517020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971277,
      NULL,
      0.838812,
      0,
      3.881986,
      3.401836,
      1.412070,
      1,
      0.841175,
      2,
      1,
      NULL,
      1.052392,
      0.049100,
      NULL,
      1.906359,
      1,
      1.404352,
      0.811796,
      0.735438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '3343',
      '',
      '',
      3,
      '23441',
      '',
      NULL,
      2.344513,
      3.073675,
      NULL,
      2,
      3.236256,
      1.779330,
      3.604155,
      0.587581,
      3);
commit;
end;
/


