set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2324020',
      25,
      3,
      3.220802,
      NULL,
      '034312',
      3,
      ' 0-10-1988',
      13,
      NULL,
      0.117435,
      NULL,
      0.137148,
      0.266383,
      NULL,
      1.776528,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      2.487517,
      NULL,
      1,
      1.408309,
      0,
      1.384812,
      NULL,
      1.603972,
      2.893225,
      NULL,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.287472,
      0.039795,
      1.484014,
      1.956874,
      NULL,
      0.293647,
      NULL,
      0.618373,
      NULL,
      NULL,
      NULL,
      NULL,
      3.224296,
      1,
      NULL,
      0,
      NULL,
      0.169402,
      1.857975,
      0,
      NULL,
      10.887589,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.581811,
      NULL,
      4.535123,
      3,
      1.877774,
      0,
      0.831380,
      1,
      0,
      NULL,
      1,
      1.232466,
      NULL,
      1,
      NULL,
      0,
      0.951792,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      NULL,
      5.978007,
      0,
      1,
      0.989435,
      NULL,
      NULL,
      0.483296,
      NULL,
      4,
      NULL,
      5,
      1.138314,
      1.462788,
      5.301315,
      1.385251,
      7,
      4,
      5.409888,
      NULL,
      3,
      0.784840,
      0.337981,
      0.003422,
      0.251719,
      1,
      3.385870,
      1.773848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546616,
      NULL,
      0,
      0,
      1.006815,
      1.460368,
      1,
      1.691566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.440158,
      0.597395,
      1.746848,
      NULL,
      1,
      2,
      1.999676,
      NULL,
      1.462256,
      NULL,
      0,
      0,
      0.185063,
      1,
      1,
      NULL,
      1,
      NULL,
      3.130327,
      2.425883,
      0,
      9,
      NULL,
      NULL,
      0,
      0.822892,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947729,
      1.072449,
      0,
      2,
      1.375900,
      1,
      2.667970,
      0.327450,
      2.975496,
      1.632413,
      1.183018,
      0.935685,
      0.175347,
      1.109485,
      0.802692,
      NULL,
      0,
      0.453770,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.376154,
      '11241',
      '',
      '',
      NULL,
      '42144',
      '',
      '',
      0.358485,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


