set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '10',
      12.668995,
      18.946174,
      NULL,
      NULL,
      5,
      NULL,
      3,
      '112141',
      5,
      ' 1-11-1998',
      31.175835,
      NULL,
      0.712838,
      NULL,
      2.376050,
      0,
      NULL,
      1,
      0.703401,
      1,
      0,
      0.519560,
      1.793741,
      NULL,
      0,
      0,
      0,
      0,
      0.301562,
      NULL,
      NULL,
      1,
      0.468853,
      0.701897,
      NULL,
      NULL,
      1.500141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.199463,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617365,
      1.724084,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914322,
      0.016679,
      1.062014,
      0,
      1,
      NULL,
      1,
      1.287099,
      0,
      0,
      0.332601,
      0.148623,
      0.953224,
      0,
      0,
      NULL,
      0,
      1.891950,
      0,
      NULL,
      1.271606,
      3,
      0.816073,
      1,
      0,
      1,
      NULL,
      0.705563,
      NULL,
      2,
      NULL,
      5.048641,
      NULL,
      0.630690,
      2.358273,
      0.003510,
      0,
      1,
      4.411535,
      3,
      0,
      2.872982,
      5.248226,
      NULL,
      1,
      3.032007,
      2.493736,
      0,
      0,
      NULL,
      NULL,
      7.119796,
      0.557770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312090,
      0.528158,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806501,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821793,
      1.360690,
      5.888533,
      0,
      2.829158,
      2,
      0.336783,
      NULL,
      NULL,
      NULL,
      1.901819,
      0,
      1.904112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.260301,
      1,
      1,
      2.889454,
      2,
      1,
      NULL,
      1.623767,
      3,
      0,
      1.189805,
      0.425725,
      NULL,
      NULL,
      NULL,
      0.885895,
      1,
      0.452825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '32222',
      '',
      0,
      NULL,
      '',
      '',
      0.067379,
      NULL,
      '',
      '',
      1,
      1.046755,
      1,
      0.198695,
      NULL,
      1,
      3,
      1,
      2);
commit;
end;
/


