set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      16,
      24.247779,
      '3032144',
      38,
      5,
      0.240413,
      2,
      '012012',
      2,
      ' 3- 1-1998',
      24,
      34.922218,
      NULL,
      NULL,
      0.104834,
      0.788767,
      NULL,
      0.629915,
      0,
      1,
      3.067073,
      1.283428,
      1.361071,
      1,
      1.762568,
      1.688712,
      NULL,
      1,
      1.730681,
      1,
      0,
      1,
      NULL,
      1,
      1.403738,
      0.393816,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795243,
      0.529158,
      1.745793,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791891,
      0.306037,
      0.825037,
      0.729795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764704,
      NULL,
      NULL,
      4,
      1,
      0.026260,
      0.134461,
      0,
      0,
      1,
      0,
      1,
      1.869568,
      1,
      1.325179,
      1.743440,
      0,
      0,
      1,
      NULL,
      1.215575,
      1.144674,
      0.544740,
      1.481823,
      5.599495,
      NULL,
      5.566809,
      0,
      4,
      2.224461,
      4,
      3,
      0,
      1.461608,
      0,
      0,
      NULL,
      0,
      1,
      2,
      5,
      NULL,
      NULL,
      6,
      1.407918,
      4.316746,
      1,
      1.896022,
      1,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956106,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.371024,
      0.791202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.860685,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.958235,
      0.697774,
      3.208110,
      2,
      1.025584,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.900340,
      NULL,
      1.380729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253369,
      0.634029,
      1,
      0.154470,
      3.698425,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1.910097,
      0.943825,
      1,
      1.387937,
      1,
      0,
      0.731971,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3323',
      '44324',
      '',
      2,
      '13444',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      1,
      NULL,
      1,
      0.443122,
      0.777514,
      3.420949,
      0.506316,
      0.937210);
commit;
end;
/


